/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef VERSION_H_STRING
#define VERSION_H_STRING

/* NOTE:
   The E2926A does not need the following assembler lines any more but
   they are still required for the E2925A */

#ifdef MINIBIOS

**********************************************************************
		sect	ver_tab,,c
**********************************************************************

bios_version    dc.b    'R4.01.02'     ; this is the BIOS version string 
		dc.b    $0
	
		end
	

#else

/* 
   This file (version.h) contains the global version string for all 
   parts of the BEST-Software. All DLLs refer to this string. It is
   important to check if all DLLs and the executable belong to the
   same version. This is checked in the swdll.cxx file at the beginning
   of the proces.
*/

extern const char * version_string;  /* this is for gui only */
extern const char * link_date_string;


/* for conditional compiling */
#define BEST_MAJOR_REVISION	BEST_6
#define BEST_MINOR_REVISION	BEST_6_02
#define BEST_BUILD		BEST_6_02_05

/* this is the GUI version string */
/* and this version string is going to support the GUI and all
   DLLs that belong to the gui!! */

#define gui_version_string	"R6.02.05"

/* this is the C-API version string,
   will be used for checking agains application */

#define capi_version_string	"R6.02.02"
/* version number for CAPI. Should reflect version string in some way */
#define capi_version_number	6,00,2,2


/* this is the svp testapi DLL version string
   NOTE: only increase this if changes have been made in the library! */
#define testapi_version_string	"3.00.2.6"
/* version number for testapi DLL. Should reflect version string somehow... */
#define testapi_version_number	3,00,2,6

/* this is the svp (>2.0) GUI version string
   NOTE: only increase this if changes have been made in the GUI! */
#define svpgui_version_string	"3.00.2.8"
/* version number for testapi DLL. Should reflect version string somehow... */
#define svpgui_version_number	3,00,2,8

/* this is the C-API version string,
   will be checked against the BIOS version string */

#define bios25_version_string	"R4.01.02"

/* Used in BestOpen() and in BestCheckBios().
   Increase when Bios has changed -> HWUpdate() will be done */
#define bios26_version_string	"R5.40.08"

/* this are the E2926A version codes. They are returned by reading the
   version code register (VersionGet()) */

#define bios_version_code	'f553'
#define core_version_code	'c26e'

#endif /* defined MINIBIOS */

/* do not add code below this line */
#endif /* defined VERSION_H_STRING */
